/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.IVWSortItem;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSPort;
import filenet.ws.api.WSPortType;
import filenet.ws.utils.WSConstants;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public final class VWWSWorkflowExplorerPanel
extends JPanel
implements ActionListener,
TreeSelectionListener,
ItemSelectable {
    private Window m_parent = null;
    private VWSession m_session = null;
    private boolean m_bFirstTime = true;
    private JSplitPane m_mainPanel = null;
    private JScrollPane m_treeScrollPane = null;
    private JPanel m_blankPanel = new JPanel();
    private JScrollPane m_workflowInfoPane = null;
    private JPanel m_workflowInfoPanel = null;
    private JPanel m_wsQueryPanel = null;
    private JTextField m_workflowNameUI = null;
    private JTextArea m_workflowDescriptionUI = null;
    private JTextArea m_workflowPartnerLinkUI = null;
    private JTextArea m_workflowWSDLURLUI = null;
    private JTextField m_workflowQueryNameUI = null;
    private JCheckBox m_workflowQueryCaseSensitiveUI = null;
    private JCheckBox m_workflowQueryExactMatchUI = null;
    private JButton m_workflowQueryExecuteBtn = null;
    private WorkflowQuery m_workflowQueryObject = null;
    private boolean m_bWorkflowQueryCaseSensitive = false;
    private boolean m_bWorkflowQueryExactMatch = false;
    private WSWorkflow m_lastSelectedWorkflow = null;
    private WSWorkflow m_currentSelectedWorkflow = null;
    private DefaultMutableTreeNode m_rootNode = null;
    private JTree m_tree = null;
    private DefaultTreeModel m_treeModel = null;
    protected ItemListener m_selectListeners = null;
    private ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());

    public VWWSWorkflowExplorerPanel(Frame parent, VWSession session) {
        super(new BorderLayout(10, 10));
        this.m_parent = parent;
        this.m_session = session;
        try {
            this.initData();
        }
        catch (Exception ex) {
            VWDebug.logException(ex, "VWWSWorkflowExplorerPanel");
        }
        this.setupLayout();
    }

    public VWWSWorkflowExplorerPanel(Dialog parent, VWSession session) {
        super(new BorderLayout(10, 10));
        this.m_parent = parent;
        this.m_session = session;
        try {
            this.initData();
        }
        catch (Exception ex) {
            VWDebug.logException(ex, "VWWSWorkflowExplorerPanel");
        }
        this.setupLayout();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bFirstTime) {
            this.m_bFirstTime = false;
            if (this.m_mainPanel != null) {
                this.m_mainPanel.setDividerLocation(0.5);
            }
        }
    }

    protected void initData() throws Exception {
        this.m_workflowQueryObject = new WorkflowQuery();
        this.m_rootNode = new DefaultMutableTreeNode(new WorkflowQuery());
    }

    protected void setupLayout() {
        this.setVisible(false);
        this.m_mainPanel = new JSplitPane(1, false);
        this.m_treeScrollPane = this.initTreePanel();
        if (this.compOrientation.isLeftToRight()) {
            this.m_mainPanel.setLeftComponent(this.m_treeScrollPane);
            this.m_mainPanel.setRightComponent(this.m_blankPanel);
        } else {
            this.m_mainPanel.setLeftComponent(this.m_blankPanel);
            this.m_mainPanel.setRightComponent(this.m_treeScrollPane);
        }
        this.m_mainPanel.setContinuousLayout(true);
        this.add((Component)this.m_mainPanel, "Center");
        this.m_tree.setSelectionInterval(0, 0);
        this.m_mainPanel.applyComponentOrientation(this.compOrientation);
    }

    private void updateWorkflowQueryPanel() {
        this.initWorkflowQueryPanel();
    }

    private void initWorkflowQueryPanel() {
        if (this.m_wsQueryPanel != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_wsQueryPanel = new JPanel();
        this.m_wsQueryPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_webServicesWorkflowQuery, 0);
        this.m_wsQueryPanel.add((Component)toolbarBorder, "First");
        JPanel panel = toolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        this.m_workflowQueryNameUI = new JTextField();
        this.m_workflowQueryNameUI.addActionListener(this);
        JPanel optionPanel = new JPanel();
        optionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VWResource.s_options));
        optionPanel.setLayout(new BoxLayout(optionPanel, 3));
        this.m_workflowQueryCaseSensitiveUI = new JCheckBox(VWResource.s_caseSensitive);
        this.m_workflowQueryCaseSensitiveUI.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_workflowQueryCaseSensitiveUI.setSelected(this.m_bWorkflowQueryCaseSensitive);
        this.m_workflowQueryCaseSensitiveUI.addActionListener(this);
        this.m_workflowQueryExactMatchUI = new JCheckBox(VWResource.s_exactMatch);
        this.m_workflowQueryExactMatchUI.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_workflowQueryExactMatchUI.setSelected(this.m_bWorkflowQueryExactMatch);
        this.m_workflowQueryExactMatchUI.addActionListener(this);
        optionPanel.add(this.m_workflowQueryCaseSensitiveUI);
        optionPanel.add(this.m_workflowQueryExactMatchUI);
        this.m_workflowQueryExecuteBtn = new JButton(VWResource.s_execute);
        this.m_workflowQueryExecuteBtn.addActionListener(this);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)nameLabel, c);
        c.gridy = 1;
        panel.add((Component)this.m_workflowQueryNameUI, c);
        c.gridy = 2;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)optionPanel, c);
        c.gridy = 3;
        c.anchor = 10;
        c.fill = 0;
        panel.add((Component)this.m_workflowQueryExecuteBtn, c);
    }

    private void initWorkflowInfoPanel() {
        if (this.m_workflowInfoPane != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_workflowInfoPanel = new JPanel();
        this.m_workflowInfoPane = new JScrollPane(this.m_workflowInfoPanel);
        this.m_workflowInfoPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_webServicesWorkflowDetails, 0);
        this.m_workflowInfoPanel.add((Component)toolbarBorder, "First");
        JPanel panel = toolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        this.m_workflowNameUI = new JTextField();
        this.m_workflowNameUI.setEditable(false);
        this.m_workflowNameUI.setBorder(null);
        JLabel descriptionLabel = new JLabel(VWResource.s_label.toString(VWResource.s_description));
        this.m_workflowDescriptionUI = new JTextArea();
        this.m_workflowDescriptionUI.setEditable(false);
        this.m_workflowDescriptionUI.setRows(3);
        this.m_workflowDescriptionUI.setColumns(20);
        this.m_workflowDescriptionUI.setLineWrap(true);
        this.m_workflowDescriptionUI.setWrapStyleWord(true);
        this.m_workflowDescriptionUI.setBackground(panel.getBackground());
        JLabel partnerLinkLabel = new JLabel(VWResource.s_label.toString(VWResource.s_partnerLinks));
        this.m_workflowPartnerLinkUI = new JTextArea();
        this.m_workflowPartnerLinkUI.setEditable(false);
        this.m_workflowPartnerLinkUI.setRows(2);
        this.m_workflowPartnerLinkUI.setColumns(20);
        this.m_workflowPartnerLinkUI.setLineWrap(true);
        this.m_workflowPartnerLinkUI.setWrapStyleWord(true);
        this.m_workflowPartnerLinkUI.setBackground(panel.getBackground());
        JLabel wsdlURLLabel = new JLabel(VWResource.s_label.toString(VWResource.s_wsdlURL));
        this.m_workflowWSDLURLUI = new JTextArea();
        this.m_workflowWSDLURLUI.setEditable(false);
        this.m_workflowWSDLURLUI.setRows(2);
        this.m_workflowWSDLURLUI.setColumns(20);
        this.m_workflowWSDLURLUI.setLineWrap(true);
        this.m_workflowWSDLURLUI.setWrapStyleWord(true);
        this.m_workflowWSDLURLUI.setBackground(panel.getBackground());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.add((Component)nameLabel, c);
        c.gridy = 1;
        panel.add((Component)this.m_workflowNameUI, c);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)descriptionLabel, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_workflowDescriptionUI), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)partnerLinkLabel, c);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_workflowPartnerLinkUI), c);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)wsdlURLLabel, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_workflowWSDLURLUI), c);
    }

    private void updateWorkflowInfoPanel(WSWorkflow workflow) {
        this.initWorkflowInfoPanel();
        if (this.m_workflowInfoPane == null || workflow == null) {
            return;
        }
        if (this.m_workflowNameUI != null) {
            this.m_workflowNameUI.setText(workflow.getName());
        }
        if (this.m_workflowDescriptionUI != null) {
            this.m_workflowDescriptionUI.setText(workflow.getDescription());
        }
        if (this.m_workflowPartnerLinkUI != null) {
            this.m_workflowPartnerLinkUI.setText(workflow.getPartnerLinks());
        }
        if (this.m_workflowDescriptionUI != null) {
            try {
                this.m_workflowWSDLURLUI.setText(workflow.getWSDLURL());
            }
            catch (Exception ex) {
                this.m_workflowWSDLURLUI.setText(null);
                VWDebug.logException(ex, "VWWSWorkflowExplorerPanel::updateWorkflowInfoPanel");
            }
        }
        this.m_workflowInfoPane.applyComponentOrientation(this.compOrientation);
        this.m_workflowInfoPane.updateUI();
    }

    public String getLastSelectedWSDLURL() throws Exception {
        if (this.m_lastSelectedWorkflow != null) {
            return this.m_lastSelectedWorkflow.getWSDLURL();
        }
        return null;
    }

    public String getSelectedWSDLURL() throws Exception {
        if (this.m_currentSelectedWorkflow != null) {
            return this.m_currentSelectedWorkflow.getWSDLURL();
        }
        return null;
    }

    private JScrollPane initTreePanel() {
        this.m_tree = new JTree(this.m_rootNode);
        this.m_tree.setCellRenderer(new TreeCellRenderer());
        this.m_tree.addTreeSelectionListener(this);
        TreeModel treeModel = this.m_tree.getModel();
        if (treeModel != null && treeModel instanceof DefaultTreeModel) {
            this.m_treeModel = (DefaultTreeModel)treeModel;
        }
        return new JScrollPane(this.m_tree);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_workflowQueryNameUI) {
            this.executeWorkflowQuery();
        } else if (source == this.m_workflowQueryExecuteBtn) {
            this.executeWorkflowQuery();
        } else if (source == this.m_workflowQueryCaseSensitiveUI) {
            this.m_bWorkflowQueryCaseSensitive = this.m_workflowQueryCaseSensitiveUI.isSelected();
        } else if (source == this.m_workflowQueryExactMatchUI) {
            this.m_bWorkflowQueryExactMatch = this.m_workflowQueryExactMatchUI.isSelected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeWorkflowQuery() {
        Cursor currentCursor;
        block11: {
            block10: {
                if (this.m_workflowQueryObject == null) return;
                currentCursor = null;
                try {
                    try {
                        currentCursor = this.getCursor();
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        if (this.m_rootNode == null) {
                            Object var7_2 = null;
                            if (currentCursor == null) return;
                            break block10;
                        }
                        Object[] workflows = this.m_workflowQueryObject.findWorkflowByName();
                        this.m_rootNode.removeAllChildren();
                        if (workflows != null && workflows.length > 0) {
                            VWQuickSort sort = new VWQuickSort(workflows, 0);
                            sort.sort(0, workflows.length - 1);
                            if (workflows != null && workflows.length != 0) {
                                for (int i = 0; i < workflows.length; ++i) {
                                    if (workflows[i] == null) continue;
                                    DefaultMutableTreeNode workflowNode = new DefaultMutableTreeNode(workflows[i]);
                                    this.m_rootNode.add(workflowNode);
                                }
                            }
                        }
                        if (this.m_treeModel != null) {
                            this.m_treeModel.nodeStructureChanged(this.m_rootNode);
                        }
                        break block11;
                    }
                    catch (Exception ex) {
                        this.showMessage(VWResource.s_failedToQueryForTModels, VWResource.s_error, 1, ex);
                        Object var7_4 = null;
                        if (currentCursor == null) return;
                        this.setCursor(currentCursor);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    if (currentCursor == null) throw throwable;
                    this.setCursor(currentCursor);
                    throw throwable;
                }
            }
            this.setCursor(currentCursor);
            return;
        }
        Object var7_3 = null;
        if (currentCursor == null) return;
        this.setCursor(currentCursor);
    }

    public synchronized void addItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.add(this.m_selectListeners, l);
    }

    public synchronized void removeItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.remove(this.m_selectListeners, l);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.m_mainPanel != null) {
            int dividerLocation = this.m_mainPanel.getDividerLocation();
            super.setBounds(x, y, width, height);
            this.m_mainPanel.setDividerLocation(dividerLocation);
        } else {
            super.setBounds(x, y, width, height);
        }
    }

    public void setBounds(Rectangle r) {
        if (this.m_mainPanel != null) {
            int dividerLocation = this.m_mainPanel.getDividerLocation();
            super.setBounds(r);
            this.m_mainPanel.setDividerLocation(dividerLocation);
        } else {
            super.setBounds(r);
        }
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private DefaultMutableTreeNode getSelectedTreeNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        return node;
    }

    public Object[] getSelectedObjects() {
        Object nodeInfo = this.getSelectedObject();
        if (nodeInfo != null) {
            Object[] objects = null;
            objects = new Object[]{nodeInfo};
            return objects;
        }
        return null;
    }

    protected void notifySelectListeners() {
        Object nodeInfo = this.getSelectedObject();
        String wsdlURL = null;
        if (nodeInfo != null && nodeInfo instanceof WSWorkflow) {
            try {
                wsdlURL = ((WSWorkflow)nodeInfo).getWSDLURL();
            }
            catch (Exception ex) {
                wsdlURL = null;
                VWDebug.logException(ex, "VWWSWorkflowExplorerPanel::notifySelectListeners");
            }
        }
        ItemEvent event = new ItemEvent(this, 0, wsdlURL, 1);
        if (this.m_selectListeners != null) {
            this.m_selectListeners.itemStateChanged(event);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object nodeInfo = this.getSelectedObject();
        JComponent newComponent = null;
        if (nodeInfo != null) {
            this.m_currentSelectedWorkflow = null;
            if (nodeInfo instanceof WorkflowQuery) {
                this.updateWorkflowQueryPanel();
                this.m_workflowQueryObject = (WorkflowQuery)nodeInfo;
                newComponent = this.m_wsQueryPanel;
            } else if (nodeInfo instanceof WSWorkflow) {
                this.updateWorkflowInfoPanel((WSWorkflow)nodeInfo);
                newComponent = this.m_workflowInfoPane;
                this.m_currentSelectedWorkflow = this.m_lastSelectedWorkflow = (WSWorkflow)nodeInfo;
            }
            this.notifySelectListeners();
            if (newComponent != null) {
                int dividerLocation = this.m_mainPanel.getDividerLocation();
                if (this.compOrientation.isLeftToRight()) {
                    this.m_mainPanel.setRightComponent(newComponent);
                } else {
                    this.m_mainPanel.setLeftComponent(newComponent);
                }
                this.m_mainPanel.setDividerLocation(dividerLocation);
                this.m_mainPanel.updateUI();
            }
        }
    }

    private String showMessage(String msg, String title, int msgType) {
        return this.showMessage(msg, title, msgType, null);
    }

    private String showMessage(String msg, String title, int msgType, Exception ex) {
        if (ex != null) {
            msg = msg == null ? new String(ex.toString()) : msg + "\n" + ex.toString();
        }
        if (this.m_parent instanceof Frame) {
            VWMessageDialog.showOptionDialog((Frame)this.m_parent, msg, title, msgType);
        } else if (this.m_parent instanceof JDialog) {
            VWMessageDialog.showOptionDialog((JDialog)this.m_parent, msg, title, msgType);
        } else {
            JOptionPane.showMessageDialog(this.m_parent, msg, title, msgType);
        }
        return msg;
    }

    class WSWorkflow
    implements IVWSortItem {
        String m_workflowName = null;
        VWWorkflowSignature m_signature = null;
        VWWorkflowDefinition m_definition = null;
        boolean m_bVersionAgnostic = false;

        WSWorkflow(String name) {
            this.m_workflowName = name;
        }

        WSWorkflow(VWWorkflowSignature signature) {
            this.m_signature = signature;
            if (signature != null) {
                this.m_workflowName = signature.getName();
                this.m_bVersionAgnostic = signature.getVersionAgnostic();
            }
        }

        public String getName() {
            return this.m_workflowName;
        }

        String getDescription() {
            if (this.m_signature != null) {
                return this.m_signature.getDescription();
            }
            return null;
        }

        int getWorkspaceId() {
            if (this.m_signature != null) {
                return this.m_signature.getWorkspaceId();
            }
            return 0;
        }

        VWWorkflowDefinition getWorkflowDefinition() {
            if (this.m_definition == null) {
                try {
                    if (this.m_signature != null && this.m_workflowName != null) {
                        this.m_definition = VWWSWorkflowExplorerPanel.this.m_session.fetchWorkflowDefinition(this.m_signature.getWorkspaceId(), this.m_workflowName, false);
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex, "VWWSWorkflowExplorerPanel::getWorkflowDefinition");
                }
            }
            return this.m_definition;
        }

        String getPartnerLinks() {
            String[] partnerLinks;
            if (this.m_signature != null && (partnerLinks = this.m_signature.getPartnerlinkNames()) != null && partnerLinks.length > 0) {
                String s = new String();
                for (int i = 0; i < partnerLinks.length; ++i) {
                    if (i != 0) {
                        s = s + "\n";
                    }
                    s = s + partnerLinks[i];
                }
                return s;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String getWSDLURL() throws Exception {
            WSDefinition wsDef;
            String WSDLLink;
            block14: {
                String m_method = "getWSDLURL";
                WSDLLink = VWIDMBaseFactory.instance().getProperties().getProperty("p8bpm.listener.url") + "/wscp" + WSConstants.UTF8Encode(VWWSWorkflowExplorerPanel.this.m_session.getConnectionPointName()) + "/wc/" + WSConstants.UTF8Encode(this.m_workflowName);
                if (!this.m_bVersionAgnostic) {
                    WSDLLink = WSDLLink + "/" + Integer.toString(this.getWorkspaceId());
                }
                WSDLLink = WSDLLink + "?wsdl";
                wsDef = null;
                WSPortType[] ports = null;
                try {
                    block13: {
                        try {
                            String b;
                            wsDef = new WSDefinition(WSDLLink);
                            ports = wsDef.getPortTypes();
                            if (ports == null || ports[0] == null) break block13;
                            String defaultPortTypeName = ports[0].getName();
                            WSPort defaultPort = wsDef.getDefaultPort(defaultPortTypeName);
                            String s = defaultPort.getEndpoint();
                            int index = s.indexOf("P8BPMWSBroker");
                            int index2 = WSDLLink.indexOf("P8BPMWSBroker");
                            WSDLLink = b = s.substring(0, index) + WSDLLink.substring(index2);
                        }
                        catch (Throwable t) {
                            Object var12_13 = null;
                            if (ports != null) {
                                for (int i = 0; i < ports.length; ++i) {
                                    ports[i] = null;
                                }
                            }
                            if (wsDef == null) return WSDLLink;
                            wsDef.releaseReferences();
                            return WSDLLink;
                        }
                    }
                    Object var12_12 = null;
                    if (ports == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    if (ports != null) {
                        for (int i = 0; i < ports.length; ++i) {
                            ports[i] = null;
                        }
                    }
                    if (wsDef == null) throw throwable;
                    wsDef.releaseReferences();
                    wsDef = null;
                    throw throwable;
                }
                for (int i = 0; i < ports.length; ++i) {
                    ports[i] = null;
                }
            }
            if (wsDef == null) return WSDLLink;
            wsDef.releaseReferences();
            return WSDLLink;
        }

        public String toString() {
            return this.getName();
        }
    }

    class WorkflowQuery {
        public String toString() {
            return VWResource.s_webServicesWorkflows;
        }

        public WSWorkflow[] findWorkflowByName() throws Exception {
            Vector<WSWorkflow> wsWorkflows = new Vector<WSWorkflow>();
            if (VWWSWorkflowExplorerPanel.this.m_workflowQueryNameUI != null && VWWSWorkflowExplorerPanel.this.m_session != null) {
                boolean bCaseSensitive = VWWSWorkflowExplorerPanel.this.m_workflowQueryCaseSensitiveUI.isSelected();
                boolean bExactMatch = VWWSWorkflowExplorerPanel.this.m_workflowQueryExactMatchUI.isSelected();
                String name = VWWSWorkflowExplorerPanel.this.m_workflowQueryNameUI.getText();
                int queryNameLen = -1;
                if (name != null) {
                    queryNameLen = name.length();
                }
                String[] wcNames = VWWSWorkflowExplorerPanel.this.m_session.fetchWorkClassNames(true);
                VWWorkflowSignature sig = null;
                if (wcNames != null && wcNames.length > 0) {
                    for (int i = 0; i < wcNames.length; ++i) {
                        String wcName = wcNames[i];
                        if (wcName == null) continue;
                        if (queryNameLen > 0 && wcName.length() >= queryNameLen) {
                            String s = null;
                            s = bExactMatch ? wcName : wcName.substring(0, queryNameLen);
                            if (!bCaseSensitive ? VWStringUtils.compareIgnoreCase(s, name) != 0 : VWStringUtils.compare(s, name) != 0) continue;
                        }
                        if ((sig = VWWSWorkflowExplorerPanel.this.m_session.fetchWorkflowSignature(wcNames[i])) == null || sig.getPartnerlinkNames() == null || sig.getPartnerlinkNames().length <= 0 || !sig.getHasMyPortType()) continue;
                        wsWorkflows.add(new WSWorkflow(sig));
                    }
                }
            }
            if (wsWorkflows != null && wsWorkflows.size() > 0) {
                WSWorkflow[] array = new WSWorkflow[wsWorkflows.size()];
                wsWorkflows.toArray(array);
                return array;
            }
            return null;
        }
    }

    class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon m_localWebServicesWorkflowIcon = VWImageLoader.createImageIcon("ws_explorer_main.gif");
        private ImageIcon m_workflowIcon = VWImageLoader.createImageIcon("ws_workflow.gif");

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value != null) {
                Object nodeInfo = null;
                String text = null;
                if (value instanceof DefaultMutableTreeNode) {
                    nodeInfo = ((DefaultMutableTreeNode)value).getUserObject();
                }
                if (nodeInfo != null) {
                    if (nodeInfo instanceof WSWorkflow) {
                        this.setIcon(this.m_workflowIcon);
                        text = ((WSWorkflow)nodeInfo).getName();
                    } else if (nodeInfo instanceof WorkflowQuery) {
                        this.setIcon(this.m_localWebServicesWorkflowIcon);
                        text = ((WorkflowQuery)nodeInfo).toString();
                    }
                    this.setText(text);
                    this.setToolTipText(text);
                }
                return this;
            }
            return comp;
        }
    }
}

